#ifndef LINK_LIST
#define LINK_LIST

#include <iostream>

template <typename T>
class ListNode{
public:
	ListNode(T d);
	virtual ~ListNode();
	
	ListNode<T>* prev;
	ListNode<T>* next;
	
	T item;
};
	
template <typename T>
class List {
private:
	ListNode<T>* first;
	ListNode<T>* last;
	int size;
	
	T remove(ListNode<T>* x);
	ListNode<T>* getNode(int pos);
public:
	List();
	virtual ~List();
	
	void addFrontNode(T d);
	void addBackNode(T d);
	void insertNodeAfter(int pos, T d);
	void setItem(int pos, T val);
	
	T getFirst();
	T getLast();
	T removePos(int pos);
	T getItem(int pos);
	
	int getSize(){ return size; }
	bool isEmpty(){ return size==0; }
	
	void print();
};

template <typename T>
ListNode<T>::ListNode(T d){
	
	prev=0;
	next=0;
	item = d;
}

template <typename T>
ListNode<T>::~ListNode(){

}

template <typename T>
List<T>::List(){
	
	first = 0;
	last = 0;
	size = 0;
}

template <typename T>
List<T>::~List(){
	
	struct ListNode<T>* next;
	while (first != 0)
	{
	    next = first->next;
	    delete first;
	    first = next;
	}
}

template <typename T>
void List<T>::addFrontNode(T d) {	// Adds a node to the front of the list.
	
	if(size==0) { first = new ListNode<T>(d); last = first;}
	else {
		ListNode<T>* t = first;	// Sets a pointer to the previous first.
		first = new ListNode<T>(d);	// Makes a new node pointed to by the first pointer.
	
		t->prev = first;	// Previous of the former first is the new first.
		
		first->next = t;	// Next of the new node is the former first.
	}
	size++;
}

template <typename T>
void List<T>::addBackNode(T d) {
	
	if(size==0) { first = new ListNode<T>(d); last = first;}
	else {
		ListNode<T>* t = last;
		last = new ListNode<T>(d);
		
		t->next = last;
		
		last->prev = t;
	}
	size++;
}

template <typename T>
T List<T>::getFirst() {	// Removes the first node and returns what its value was.
	
	try {
		if (size == 0) { throw 0; }
		else { return remove(first); }
	}
	catch(int e) {
		std::cout << "\n\n--An exception occurred! The list is empty!--\n\n";
	}
}

template <typename T>
T List<T>::getLast() {
	
	try {
		if (size == 0) { throw 0; }
		else { return remove(last); }
	}
	catch(int e) {
		std::cout << "\n\n--An exception occurred! The list is empty!--\n\n";
	}
}

template <typename T>
T List<T>::remove(ListNode<T>* x) {
	
	T ret = x->item;
	
	if (size==1) {
		first = 0;
		last = 0;
	}
	else if (x == first) {	// If it's the first node, set the next's previous to NULL.
		x->next->prev = 0;
		first = x->next;
	}
	else if (x == last) {	// If it's the last node, sets the previous next to NULL.
		x->prev->next = 0;
		last = x->prev;
	}
	else {	// If it's not the first or last node, sets the surrounding previous and next pointers to skip it.
		x->prev->next = x->next;
		x->next->prev = x->prev;
	}
	
	delete x;
	size--;
	return ret;
}

template <typename T>
ListNode<T>* List<T>::getNode(int pos) { // Gets a node from the position number.
	
	ListNode<T>* curr = first;
	
	for (int i = 1; i < pos; i++) {	// Transverses the list to the given position.
	
		if (curr == last) {
			break;
		}
		else {
			curr = curr->next;
		}
	}

	return curr;
}

template <typename T>
void List<T>::setItem(int pos, T val) {	// Sets (or changes) the item value of a node.
	
	ListNode<T>* curr = List<T>::getNode(pos); // Gets the node at the given pos.
	curr->item = val;	// Sets its item to the given value.
	return;
}

template <typename T>
void List<T>::insertNodeAfter(int pos, T d) {	// Inserts a new node after existing link at x.
	
	ListNode<T>* add = new ListNode<T>(d);
	if(size==0) { first = add; last = first; }
	else {
		ListNode<T>* curr = List<T>::getNode(pos); // Gets the node at the given position.
		
		if (curr != last) {
			add->next = curr->next;
			curr->next->prev = add;
		}
		else {
			last = add;
			add->next = 0;
		}
		curr->next = add;
		add->prev = curr;
	}
	size++;
}

template <typename T>
T List<T>::removePos(int pos) {	// Removes a node at a given position and returns its value.
	
	ListNode<T>* curr = List<T>::getNode(pos);
	T ret = curr->item;
	remove(curr);
	return ret;
}

template <typename T>
T List<T>::getItem(int pos) {	// Gets the value of a node at a given position...
	
	ListNode<T>* curr = List<T>::getNode(pos);
	return curr->item;
}

template <typename T>
void List<T>::print() {
	
	ListNode<T>* curr = first;
	std::cout << curr->item;
	while (curr != last) {
		curr = curr->next;
		std::cout << "\t" + curr->item;
	}
}

#endif
