#ifndef GRAPH_DIRECTED
#define GRAPH_DIRECTED

#include <string>
#include <List.h>

// A general basic implementation of a directed graph that uses designated type
// values for the edges and std::string IDs for the vertices.

template <typename T>
struct Edge {
	std::string from, to;
	T value;
	
	Edge(T d, std::string v, std::string b);
	virtual ~Edge();
};

template <typename T>
Edge<T>::Edge(T d, std::string v, std::string b) {
	value = d;
	from = v;
	to = b;
}

template <typename T>
Edge<T>::~Edge() {
}

template <typename T>
struct Vertex {
	std::string ID;
	List< Edge<T>* >* edges;
	
	Vertex(std::string d);
	virtual ~Vertex();
	void addEdge(Edge<T>* e);
	
	std::string getEdgeTarget(T e);
	std::string appendEdgeTargets(T e, std::string);
	
	void print();
private:
	int numOfE;
};

template <typename T>
Vertex<T>::Vertex(std::string d) {
	ID = d;
	numOfE = 0;
	edges = new List< Edge <T>* > ();
}

template <typename T>
Vertex<T>::~Vertex() {
	delete edges;
}

template <typename T>
void Vertex<T>::addEdge(Edge<T>* e) {
	edges->addBackNode(e);
	numOfE++;
}

template <typename T>
std::string Vertex<T>::getEdgeTarget(T e) {
	
	for (int x = 0; x<numOfE; x++) {
		Edge<T>* curr = edges->getItem(x+1);
		if (curr->value == e) {
			return curr->to;
		}
	}
	return "Edge DNE.";
}

template <typename T>
std::string Vertex<T>::appendEdgeTargets(T e, std::string toAppend) {
	
	bool found = false;
	
	for (int x = 0; x<numOfE; x++) {
		Edge<T>* curr = edges->getItem(x+1);
		if (curr->value == e) {
			toAppend.append(curr->to + ", ");
			found = true;
		}
	}
	if (found) { return toAppend; }
	else { return "Edge DNE."; }
}

template <typename T>
void Vertex<T>::print() {

	std::cout << "\n\n" + ID + ": ";
	for (int x = 0; x<numOfE; x++) {
		Edge<T>* curr = edges->getItem(x+1);
		std::cout << curr->value + "->" + curr->to + " ";
	}
}

template <typename T>
class GRAPH {
private:
	List< Vertex<T>* >* vertices;	
	List< Edge<T>* >* allEdges;
	int numOfV;
	int numOfE;
public:
	GRAPH();
	virtual ~GRAPH();
	
	int getNumOfV() {
		return numOfV;
	}
	int getNumOfE() {
		return numOfE;
	}
	
	bool addVertex(std::string s);
	bool addEdge(T d, std::string a, std::string b);
	
	std::string getEdgeTarget(std::string v, T e);
	std::string appendTargetsToString(std::string v, T e, std::string);
	
	void print();
};

template <typename T>
GRAPH<T>::GRAPH() {
	vertices = new List< Vertex <T>* > ();
	allEdges = new List< Edge <T>* > ();
	numOfE = 0;
	numOfV = 0;
}

template <typename T>
GRAPH<T>::~GRAPH() {
	
	delete allEdges;
	delete vertices;
}

template <typename T>
bool GRAPH<T>::addVertex(std::string s) {
	for (int x = 0; x<numOfV; x++) {
		Vertex<T>* curr = vertices->getItem(x+1);
		if (curr->ID == s) {
			return 0;	
		}
	}
	
	Vertex<T>* v = new Vertex<T>(s);
	vertices->addBackNode(v);
	numOfV++;
	return 1;
}

template <typename T>
bool GRAPH<T>::addEdge(T d, std::string a, std::string b) {
	
	for (int x = 0; x<numOfE; x++) {
		Edge<T>* curr = allEdges->getItem(x+1);
		if (curr->value == d && curr->to == b
			&& curr-> from == a) {
			return 0;
		}
	}
	Edge<T>* e = new Edge<T>(d, a, b);
	allEdges->addBackNode(e);
	numOfE++;
		
	for (int x = 0; x<numOfV; x++) {
		Vertex<T>* curr = vertices->getItem(x+1);
		if (curr->ID == a) {
			curr->addEdge(e);
		}
	}
	
	return 1;
}

template <typename T>
std::string GRAPH<T>::getEdgeTarget(std::string v, T e) {
	
	for (int x = 0; x<numOfV; x++) {
		Vertex<T>* curr = vertices->getItem(x+1);
		if (curr->ID == v) {
			return curr->getEdgeTarget(e);
		}
	}
	return "\nError: Can't find vertex...\n\n";
}

template <typename T>
std::string GRAPH<T>::appendTargetsToString(std::string v, T e, std::string toAppend) {
	
	for (int x = 0; x<numOfV; x++) {
		Vertex<T>* curr = vertices->getItem(x+1);
		if (curr->ID == v) {
			return curr->appendEdgeTargets(e, toAppend);
		}
	}
	return "\nError: Can't find vertex...\n\n";
}

template <typename T>
void GRAPH<T>::print() {
	
	for (int x = 0; x<numOfV; x++) {
		Vertex<T>* curr = vertices->getItem(x+1);
		curr->print();
	}
}

#endif