#ifndef FA_CONVERTER
#define FA_CONVERTER

#include "FiniteAutomata.h"


class Converter {
private:
	static std::string AppendTargets(GRAPH<std::string>* graph, std::string startState, int count);
public:
	static FiniteAutomata* ReadData(char* path); // Reads in an NFA from a file.
	static FiniteAutomata* ConvertData(FiniteAutomata*); // Converts the NFA to a DFA.
	static void WriteData(FiniteAutomata*); // Writes the DFA to a file.
	static std::string sortVertex(std::string); // Sorts the DFA vertices into lexicographical order.
	static std::string RemoveDupes(std::string); // Removes the duplicate Accept States from the DFA's string.
	static std::string RemoveDupesStartGen(std::string);
};



#endif